/*******************************************************************************
* File:    vectors.c
*
* Purpose: Configure interrupt vector table for MC56F801x devices.
* Author:  Quinten Brooks, Freescale Semiconductor MCD IC Design - Phoenix
* Email:   quinten.brooks@freescale.com
* Date:    2007.03.12
*
********************************************************************************
* Notes:   
*
*******************************************************************************/

#include "util.h"


/*******************************************************************************
* Exception Vector Table
*******************************************************************************/
#pragma section VECTOR_TABLE begin
asm void vector_table()
{
   jmp >VECTOR_000              // Hardware Reset
   jmp >VECTOR_001              // COP Reset
   jsr >VECTOR_002              // CPU Illegal Instruction
   jsr >VECTOR_003              // CPU HW Stack Overflow
   jsr >VECTOR_004              // CPU Misaligned Long Access
   jsr >VECTOR_005              // CPU EOnCE Step Counter
   jsr >VECTOR_006              // CPU EOnCE Breakpoint Unit 0
   jsr >VECTOR_007              // CPU EOnCE Trace Buffer
   jsr >VECTOR_008              // CPU EOnCE Transmit Register Empty
   jsr >VECTOR_009              // CPU EOnCE Receive Register Full
   jsr >VECTOR_010              // PMC Out Of Regulation
   jsr >VECTOR_011              // OCCS (Loss of Lock 0-1, Loss of Referece Clock)
   jsr >VECTOR_012              // ADCA Conversion Complete
   jsr >VECTOR_013              // ADCB Conversion Complete
   jsr >VECTOR_014              // PWM (Reload, Fault)
   jsr >VECTOR_015              // CMP0 (Flag Rising, Flag Falling)
   jsr >VECTOR_016              // CMP1 (Flag Rising, Flag Falling)
   jsr >VECTOR_017              // CMP2 (Flag Rising, Flag Falling)
   jsr >VECTOR_018              // HFM (Access Error, Command Complete, Buffer Empty)
   jsr >VECTOR_019              // SPI (RX Full, RX Overflow, RX Mode Fault)
   jsr >VECTOR_020              // SPI TX Empty
   jsr >VECTOR_021              // SCI (TX Empty, TX Idle)
   jsr >VECTOR_022              // SCI (RX Error, RX Full/Overrun)
   jsr >VECTOR_023              // I2C (TX Complete, Match, Arb Lost, Timeout)
   jsr >VECTOR_024              // PIT
   jsr >VECTOR_025              // TMR0 (Compare, Overflow, Input Edge, Compare 1-2)
   jsr >VECTOR_026              // TMR1 (Compare, Overflow, Input Edge, Compare 1-2)
   jsr >VECTOR_027              // GPIOA
   jsr >VECTOR_028              // GPIOB
   jsr >VECTOR_029              // GPIOC
   jsr >VECTOR_030              // GPIOD
   jsr >VECTOR_031              // GPIOE
   jsr >VECTOR_032              // GPIOF
   jsr >VECTOR_033              // Real Time Clock
   jsr >VECTOR_034              // RESERVED
   jsr >VECTOR_035              // RESERVED
   jsr >VECTOR_036              // RESERVED
   jsr >VECTOR_037              // RESERVED
   jsr >VECTOR_038              // RESERVED
   jsr >VECTOR_039              // RESERVED
   jsr >VECTOR_040              // SW Interrupt 0
   jsr >VECTOR_041              // SW Interrupt 1
   jsr >VECTOR_042              // SW Interrupt 2
   jsr >VECTOR_043              // SW Interrupt 3
   jsr >VECTOR_044              // SW Interrupt Low Priority
   jsr >VECTOR_045              // User Programmable L1 Interrupt
   jsr >VECTOR_046              // User Programmable L1 Interrupt
   jsr >VECTOR_047              // User Programmable L1 Interrupt
   jsr >VECTOR_048              // User Programmable L2 Interrupt
   jsr >VECTOR_049              // User Programmable L2 Interrupt
#ifndef FAST_ISR
   jsr >VECTOR_050              // User Programmable L2 Interrupt (or Fast Interrupt)
#endif
}
#pragma section VECTOR_TABLE end


/*******************************************************************************
* Exception Vector Table (RAM)
*******************************************************************************/
#pragma section VECTOR_TABLE_RAM begin
asm void vector_table_ram()
{
   jmp >VECTOR_000              // Hardware Reset
   jmp >VECTOR_001              // COP Reset
   jsr >VECTOR_002              // CPU Illegal Instruction
   jsr >VECTOR_003              // CPU HW Stack Overflow
   jsr >VECTOR_004              // CPU Misaligned Long Access
   jsr >VECTOR_005              // CPU EOnCE Step Counter
   jsr >VECTOR_006              // CPU EOnCE Breakpoint Unit 0
   jsr >VECTOR_007              // CPU EOnCE Trace Buffer
   jsr >VECTOR_008              // CPU EOnCE Transmit Register Empty
   jsr >VECTOR_009              // CPU EOnCE Receive Register Full
   jsr >VECTOR_010              // PMC Out Of Regulation
   jsr >VECTOR_011              // OCCS (Loss of Lock 0-1, Loss of Referece Clock)
   jsr >VECTOR_012              // ADCA Conversion Complete
   jsr >VECTOR_013              // ADCB Conversion Complete
   jsr >VECTOR_014              // PWM (Reload, Fault)
   jsr >VECTOR_015              // CMP0 (Flag Rising, Flag Falling)
   jsr >VECTOR_016              // CMP1 (Flag Rising, Flag Falling)
   jsr >VECTOR_017              // CMP2 (Flag Rising, Flag Falling)
   jsr >VECTOR_018              // HFM (Access Error, Command Complete, Buffer Empty)
   jsr >VECTOR_019              // SPI (RX Full, RX Overflow, RX Mode Fault)
   jsr >VECTOR_020              // SPI TX Empty
   jsr >VECTOR_021              // SCI (TX Empty, TX Idle)
   jsr >VECTOR_022              // SCI (RX Error, RX Full/Overrun)
   jsr >VECTOR_023              // I2C (TX Complete, Match, Arb Lost, Timeout)
   jsr >VECTOR_024              // PIT
   jsr >VECTOR_025              // TMR0 (Compare, Overflow, Input Edge, Compare 1-2)
   jsr >VECTOR_026              // TMR1 (Compare, Overflow, Input Edge, Compare 1-2)
   jsr >VECTOR_027              // GPIOA
   jsr >VECTOR_028              // GPIOB
   jsr >VECTOR_029              // GPIOC
   jsr >VECTOR_030              // GPIOD
   jsr >VECTOR_031              // GPIOE
   jsr >VECTOR_032              // GPIOF
   jsr >VECTOR_033              // Real Time Clock
   jsr >VECTOR_034              // RESERVED
   jsr >VECTOR_035              // RESERVED
   jsr >VECTOR_036              // RESERVED
   jsr >VECTOR_037              // RESERVED
   jsr >VECTOR_038              // RESERVED
   jsr >VECTOR_039              // RESERVED
   jsr >VECTOR_040              // SW Interrupt 0
   jsr >VECTOR_041              // SW Interrupt 1
   jsr >VECTOR_042              // SW Interrupt 2
   jsr >VECTOR_043              // SW Interrupt 3
   jsr >VECTOR_044              // SW Interrupt Low Priority
   jsr >VECTOR_045              // User Programmable L1 Interrupt
   jsr >VECTOR_046              // User Programmable L1 Interrupt
   jsr >VECTOR_047              // User Programmable L1 Interrupt
   jsr >VECTOR_048              // User Programmable L2 Interrupt
   jsr >VECTOR_049              // User Programmable L2 Interrupt
#ifndef FAST_ISR
   jsr >VECTOR_050              // User Programmable L2 Interrupt (or Fast Interrupt)
#endif
}
#pragma section VECTOR_TABLE_RAM end


/* End of "vectors.c" */
